/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.seasons.mixin;

import io.github.lucaargolo.seasons.FabricSeasons;
import io.github.lucaargolo.seasons.colors.SeasonFoliageColors;
import io.github.lucaargolo.seasons.colors.SeasonGrassColors;
import io.github.lucaargolo.seasons.utils.ColorsCache;
import java.util.Optional;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4763;
import net.minecraft.class_638;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={class_1959.class})
public class BiomeMixin {
    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/world/biome/BiomeEffects;getGrassColor()Ljava/util/Optional;"), method={"getGrassColorAt"})
    public Optional<Integer> getSeasonGrassColor(class_4763 effects) {
        class_2960 biomeIdentifier;
        Optional<Integer> seasonGrassColor;
        class_1959 biome = (class_1959)this;
        if (ColorsCache.hasGrassCache(biome)) {
            return ColorsCache.getGrassCache(biome);
        }
        Optional<Integer> returnColor = effects.method_30812();
        class_638 world = class_310.method_1551().field_1687;
        if (world != null && (seasonGrassColor = FabricSeasons.CONFIG.getSeasonGrassColor(biome, biomeIdentifier = world.method_30349().method_30530(class_2378.field_25114).method_10221((Object)biome), FabricSeasons.getCurrentSeason())).isPresent()) {
            returnColor = seasonGrassColor;
        }
        ColorsCache.createGrassCache(biome, returnColor);
        return returnColor;
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/world/biome/BiomeEffects;getFoliageColor()Ljava/util/Optional;"), method={"getFoliageColor"})
    public Optional<Integer> getSeasonFoliageColor(class_4763 effects) {
        class_2960 biomeIdentifier;
        Optional<Integer> seasonFoliageColor;
        class_1959 biome = (class_1959)this;
        if (ColorsCache.hasFoliageCache(biome)) {
            return ColorsCache.getFoliageCache(biome);
        }
        Optional<Integer> returnColor = effects.method_30811();
        class_638 world = class_310.method_1551().field_1687;
        if (world != null && (seasonFoliageColor = FabricSeasons.CONFIG.getSeasonFoliageColor(biome, biomeIdentifier = world.method_30349().method_30530(class_2378.field_25114).method_10221((Object)biome), FabricSeasons.getCurrentSeason())).isPresent()) {
            returnColor = seasonFoliageColor;
        }
        ColorsCache.createFoliageCache(biome, returnColor);
        return returnColor;
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/world/biome/BiomeEffects$GrassColorModifier;getModifiedGrassColor(DDI)I"), method={"getGrassColorAt"})
    public int getSeasonModifiedGrassColor(class_4763.class_5486 gcm, double x, double z, int color) {
        if (gcm == class_4763.class_5486.field_26428) {
            int swampColor1 = FabricSeasons.CONFIG.getMinecraftSwampGrass1().getColor(FabricSeasons.getCurrentSeason());
            int swampColor2 = FabricSeasons.CONFIG.getMinecraftSwampGrass2().getColor(FabricSeasons.getCurrentSeason());
            double d = class_1959.field_9324.method_16451(x * 0.0225, z * 0.0225, false);
            return d < -0.1 ? swampColor1 : swampColor2;
        }
        return gcm.method_30823(x, z, color);
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/client/color/world/FoliageColors;getColor(DD)I"), method={"getDefaultFoliageColor"})
    public int getSeasonDefaultFolliageColor(double d, double e) {
        return SeasonFoliageColors.getColor(FabricSeasons.getCurrentSeason(), d, e);
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/client/color/world/GrassColors;getColor(DD)I"), method={"getDefaultGrassColor"})
    public int getSeasonDefaultGrassColor(double d, double e) {
        return SeasonGrassColors.getColor(FabricSeasons.getCurrentSeason(), d, e);
    }
}

